<?php
/**
 * Background Mask Style - Bean.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Bean
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Bean extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Bean', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path d="M0,1440H1920V0H0ZM729.79,450c112.5,8.65,199.22-58.32,293-101.82,36.35-25.81,75.42-47.67,120.66-60.64,411.05-130.29,634.07,288.11,369.08,599.49-3.24,4.19-6.56,8.32-9.91,12.42-47.1,57.67-104.37,106.58-168.16,146.51-333,208.45-851,170.72-1006.95-133.47-18.53-36.13-20.8-89.14-3.36-140-10.74-23.07-22-46.55-26.65-72C253.28,457.35,515.27,433.55,729.79,450Z"/>
									<path fill-opacity=".4" d="M1178.93,307.43c-57.11.78-107.59,18.28-156.1,40.78,36.35-25.81,75.42-47.67,120.66-60.64,411.05-130.29,634.07,288.11,369.08,599.49-3.24,4.19-6.56,8.32-9.91,12.42C1683.16,653.44,1539.44,291.86,1178.93,307.43ZM324.19,772.53c-17.44,50.85-15.17,103.86,3.36,140,156,304.19,674,341.92,1007,133.47C1004.57,1239.39,478.65,1104.63,324.19,772.53Z"/>',
					'portrait'  => '<path d="M0,0V2560H1920V0ZM1512.57,1447.06c-3.24,4.19-6.56,8.32-9.91,12.42-47.1,57.67-104.37,106.58-168.16,146.51-333,208.45-851,170.72-1006.95-133.47-18.53-36.13-20.8-89.14-3.36-140-10.74-23.07-22-46.55-26.65-72-44.26-243.16,217.73-267,432.25-250.48,112.5,8.65,199.22-58.32,293-101.82,36.35-25.81,75.42-47.67,120.67-60.64C1554.54,717.28,1777.56,1135.68,1512.57,1447.06Z"/>
									<path fill-opacity=".4" d="M1512.57,1447.06c-3.24,4.19-6.56,8.32-9.91,12.42,180.5-246,36.78-607.62-323.73-592.05-57.11.78-107.59,18.28-156.1,40.78,36.35-25.81,75.42-47.67,120.67-60.64C1554.54,717.28,1777.56,1135.68,1512.57,1447.06ZM324.19,1332.53c-17.44,50.85-15.17,103.86,3.36,140,156,304.19,674,341.92,1007,133.47C1004.57,1799.39,478.65,1664.63,324.19,1332.53Z"/>',
					'square'    => '<path d="M0,1920H1920V0H0ZM729.79,690c112.5,8.65,199.22-58.32,293-101.82,36.35-25.81,75.42-47.67,120.67-60.64,411-130.29,634.06,288.11,369.07,599.49-3.24,4.19-6.56,8.32-9.91,12.42-47.1,57.67-104.37,106.58-168.16,146.51-333,208.45-851,170.72-1006.95-133.47-18.53-36.13-20.8-89.14-3.36-140-10.74-23.07-22-46.55-26.65-72C253.28,697.35,515.27,673.55,729.79,690Z"/>
									<path fill-opacity=".4" d="M1334.5,1286c-333,208.45-851,170.72-1006.95-133.47-18.53-36.13-20.8-89.14-3.36-140C478.65,1344.63,1004.57,1479.39,1334.5,1286Zm168.16-146.51c3.35-4.1,6.67-8.23,9.91-12.42,265-311.38,42-729.78-369.07-599.49-45.25,13-84.32,34.83-120.67,60.64,48.51-22.5,99-40,156.1-40.78C1539.44,531.86,1683.16,893.44,1502.66,1139.48Z"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path fill-opacity=".4" d="M1178.93,307.43c-57.11.78-107.59,18.28-156.1,40.78,36.35-25.81,75.42-47.67,120.66-60.64,411.05-130.29,634.07,288.11,369.08,599.49-3.24,4.19-6.56,8.32-9.91,12.42C1683.16,653.44,1539.44,291.86,1178.93,307.43ZM324.19,772.53c-17.44,50.85-15.17,103.86,3.36,140,156,304.19,674,341.92,1007,133.47C1004.57,1239.39,478.65,1104.63,324.19,772.53Z"/>
									<path d="M324.19,772.53c154.46,332.1,680.38,466.86,1010.31,273.46,63.79-39.93,121.06-88.84,168.16-146.51,180.5-246,36.78-607.62-323.73-592-57.11.78-107.59,18.28-156.1,40.78C929,391.71,842.29,458.68,729.79,450c-214.52-16.48-476.51,7.32-432.25,250.48C302.18,726,313.45,749.46,324.19,772.53Z"/>',
					'portrait'  => '<path fill-opacity=".4" d="M1512.57,1447.06c-3.24,4.19-6.56,8.32-9.91,12.42,180.5-246,36.78-607.62-323.73-592.05-57.11.78-107.59,18.28-156.1,40.78,36.35-25.81,75.42-47.67,120.67-60.64C1554.54,717.28,1777.56,1135.68,1512.57,1447.06ZM324.19,1332.53c-17.44,50.85-15.17,103.86,3.36,140,156,304.19,674,341.92,1007,133.47C1004.57,1799.39,478.65,1664.63,324.19,1332.53Z"/>
									<path d="M1178.93,867.43c-57.11.78-107.59,18.28-156.1,40.78-93.82,43.5-180.54,110.47-293,101.82-214.52-16.48-476.51,7.32-432.25,250.48,4.64,25.47,15.91,49,26.65,72,154.46,332.1,680.38,466.86,1010.31,273.46,63.79-39.93,121.06-88.84,168.16-146.51C1683.16,1213.44,1539.44,851.86,1178.93,867.43Z"/>',
					'square'    => '<path fill-opacity=".4" d="M1334.5,1286c-333,208.45-851,170.72-1006.95-133.47-18.53-36.13-20.8-89.14-3.36-140C478.65,1344.63,1004.57,1479.39,1334.5,1286Zm168.16-146.51c3.35-4.1,6.67-8.23,9.91-12.42,265-311.38,42-729.78-369.07-599.49-45.25,13-84.32,34.83-120.67,60.64,48.51-22.5,99-40,156.1-40.78C1539.44,531.86,1683.16,893.44,1502.66,1139.48Z"/>
									<path d="M324.19,1012.53c154.46,332.1,680.38,466.86,1010.31,273.46,63.79-39.93,121.06-88.84,168.16-146.51,180.5-246,36.78-607.62-323.73-592.05-57.11.78-107.59,18.28-156.1,40.78C929,631.71,842.29,698.68,729.79,690c-214.52-16.48-476.51,7.32-432.25,250.48C302.18,966,313.45,989.46,324.19,1012.53Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path d="M0,1440H1920V0H0ZM720.14,861.63c22.44-87.43-18.28-165.06-39.52-245-15.28-32.23-27.07-66-31-103.49-45.54-341.95,315.07-459.52,523.58-207.5,2.85,3.14,5.64,6.32,8.4,9.53,38.9,45.12,69.48,97,92.08,152.84,118,291.28,16.28,694.15-245.05,774.78-31,9.58-73.11,4-110.75-16.79-19.67,5.24-39.74,10.87-60.45,11C659.71,1238.06,677.35,1028.35,720.14,861.63Z"/>
									<path fill-opacity=".4" d="M670.18,488c-7.32,45.11-.54,87.31,10.44,128.66-15.28-32.23-27.07-66-31-103.49-45.54-341.95,315.07-459.52,523.58-207.5,2.85,3.14,5.64,6.32,8.4,9.53C1012.83,138.78,708,201.78,670.18,488Zm247.69,738c37.64,20.8,79.72,26.37,110.75,16.79,261.33-80.63,363-483.5,245.05-774.78C1380.2,754.8,1201,1150.42,917.87,1226Z"/>',
					'portrait'  => '<path d="M0,0V2560H1920V0ZM1220.47,764.83c3.56,3.93,7,7.91,10.51,11.92,48.63,56.4,86.84,121.29,115.09,191,147.47,364.1,20.35,867.69-306.3,968.48-38.8,12-91.4,5-138.44-21-24.59,6.56-49.67,13.59-75.56,13.73-247.15,1.36-225.1-260.77-171.61-469.17,28.05-109.3-22.85-206.33-49.4-306.27-19.1-40.28-33.84-82.56-38.76-129.37C509.07,596.77,959.84,449.8,1220.47,764.83Z"/>
  									<path fill-opacity=".4" d="M1220.47,764.83c3.56,3.93,7,7.91,10.51,11.92C1020,556.27,639,635,591.72,992.75c-9.15,56.38-.68,109.13,13,160.82-19.1-40.28-33.84-82.56-38.76-129.37C509.07,596.77,959.84,449.8,1220.47,764.83ZM901.33,1915.28c47,26,99.64,33,138.44,21,326.65-100.79,453.77-604.38,306.3-968.48C1479.24,1326.3,1255.2,1820.83,901.33,1915.28Z"/>',
					'square'    => '<path d="M0,1920H1920V0H0Zm654.16-780.16c28.05-109.3-22.85-206.33-49.4-306.28C585.66,793.29,570.92,751,566,704.2c-56.93-427.43,393.84-574.4,654.47-259.37,3.56,3.93,7,7.91,10.51,11.92,48.63,56.4,86.84,121.29,115.09,191,147.47,364.1,20.35,867.69-306.3,968.48-38.8,12-91.4,5-138.44-21-24.59,6.56-49.67,13.59-75.56,13.73C578.62,1610.37,600.67,1348.24,654.16,1139.84Z"/>
									<path fill-opacity=".4" d="M1346.07,647.79c147.47,364.1,20.35,867.69-306.3,968.48-38.8,12-91.4,5-138.44-21C1255.2,1500.83,1479.24,1006.3,1346.07,647.79ZM1231,456.75c-3.46-4-7-8-10.51-11.92C959.84,129.8,509.07,276.77,566,704.2c4.92,46.81,19.66,89.09,38.76,129.36-13.72-51.68-22.19-104.43-13-160.81C639,315,1020,236.27,1231,456.75Z"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path fill-opacity=".4" d="M670.18,488c-7.32,45.11-.54,87.31,10.44,128.66-15.28-32.23-27.07-66-31-103.49-45.54-341.95,315.07-459.52,523.58-207.5,2.85,3.14,5.64,6.32,8.4,9.53C1012.83,138.78,708,201.78,670.18,488Zm247.69,738c37.64,20.8,79.72,26.37,110.75,16.79,261.33-80.63,363-483.5,245.05-774.78C1380.2,754.8,1201,1150.42,917.87,1226Z"/>
									<path d="M917.87,1226c283.1-75.57,462.33-471.19,355.8-758-22.6-55.8-53.18-107.72-92.08-152.84C1012.83,138.78,708,201.78,670.18,488c-7.32,45.11-.54,87.31,10.44,128.66,21.24,80,62,157.58,39.52,245-42.79,166.72-60.43,376.43,137.28,375.34C878.13,1236.86,898.2,1231.23,917.87,1226Z"/>',
					'portrait'  => '<path fill-opacity=".4" d="M1220.47,764.83c3.56,3.93,7,7.91,10.51,11.92C1020,556.27,639,635,591.72,992.75c-9.15,56.38-.68,109.13,13,160.82-19.1-40.28-33.84-82.56-38.76-129.37C509.07,596.77,959.84,449.8,1220.47,764.83ZM901.33,1915.28c47,26,99.64,33,138.44,21,326.65-100.79,453.77-604.38,306.3-968.48C1479.24,1326.3,1255.2,1820.83,901.33,1915.28Z"/>
									<path d="M591.72,992.75c-9.15,56.38-.68,109.13,13,160.82,26.55,99.94,77.45,197,49.4,306.27-53.49,208.4-75.54,470.53,171.61,469.17,25.89-.14,51-7.17,75.56-13.73,353.87-94.45,577.91-589,444.74-947.49-28.25-69.75-66.46-134.64-115.09-191C1020,556.27,639,635,591.72,992.75Z"/>',
					'square'    => '<path fill-opacity=".4" d="M1346.07,647.79c147.47,364.1,20.35,867.69-306.3,968.48-38.8,12-91.4,5-138.44-21C1255.2,1500.83,1479.24,1006.3,1346.07,647.79ZM1231,456.75c-3.46-4-7-8-10.51-11.92C959.84,129.8,509.07,276.77,566,704.2c4.92,46.81,19.66,89.09,38.76,129.36-13.72-51.68-22.19-104.43-13-160.81C639,315,1020,236.27,1231,456.75Z"/>
									<path d="M901.33,1595.28c353.87-94.45,577.91-589,444.74-947.49-28.25-69.75-66.46-134.64-115.09-191C1020,236.27,639,315,591.72,672.75c-9.15,56.38-.68,109.13,13,160.81,26.55,100,77.45,197,49.4,306.28-53.49,208.4-75.54,470.53,171.61,469.17C851.66,1608.87,876.74,1601.84,901.33,1595.28Z"/>',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Bean();
